﻿<%@ Control Language="vb" AutoEventWireup="false" CodeBehind="HotAirStationTools.ascx.vb" Inherits="Web.HotAirStationTools" %>
<%@ Register Src="~/private/stations/base/Sections/ControlMode.ascx" TagName="cu_controlmode" TagPrefix="uc" %>

<asp:UpdatePanel runat="server" ID="UpdatePanelSliderHerramientas" UpdateMode="Conditional">
    <ContentTemplate>
        <div class="mode-panel nomarginbottom">

            <div class="holder">
                <uc:cu_controlmode ID="cu_controlmode" runat="server" Visible="false" />

                <ul class="pagination">
                    <asp:Repeater ID="repeater_puertos" runat="server" OnItemCommand="repeater_puertos_ItemCommand">
                        <ItemTemplate>
                            <li class='<%# Eval("State")%>'>
                                <asp:LinkButton ID="BtnPuerto" runat="server" CommandArgument='<%# Eval("PortNumber")%>' Visible='<%# Eval("Active")%>'><%# Eval("PortNumber")%></asp:LinkButton>
                            </li>
                        </ItemTemplate>
                    </asp:Repeater>
                </ul>

                <div class="expandable-carousel menu-herramientas">
                    <div class="mask">
                        <div class="slideset item-ajax-tabset">
                            <asp:Repeater ID="repeater_herramientas" runat="server" OnItemCommand="repeater_herramientas_ItemCommand">
                                <ItemTemplate>
                                    <div class='slide <%# Eval("State")%>' style="position: relative;">
                                        <span class='numPunta <%# If(Trim(CStr(Eval("ActivePort"))) = String.Empty, "nodisplay", String.Empty)%>'><%# Eval("ActivePort")%></span>
                                        <div class="holder">
                                            <asp:LinkButton ID="btnHerramienta" runat="server" CommandArgument='<%# Eval("Tool")%>' Style='<%# "background-image:url(" & ResolveUrl("~/App_Themes/Web/images/") & Eval("Image") & "@2x.png)"%>'></asp:LinkButton>
                                        </div>
                                    </div>
                                </ItemTemplate>
                            </asp:Repeater>
                        </div>
                    </div>
                    <a class="btn-prev" href="#">Previous</a>
                    <a class="btn-next" href="#">Next</a>
                    <div class="opener-panel">
                        <asp:LinkButton ID="btnOpener" CssClass="opener" runat="server">open/close</asp:LinkButton>
                    </div>
                </div>
            </div>

            <!-- controles ocultos-->
            <asp:HiddenField ID="hdnHerramientas" runat="server" />
            <asp:HiddenField ID="hdnHerrActiva" runat="server" />
            <asp:HiddenField ID="hdnPortActivo" runat="server" />
            <asp:HiddenField ID="hdnNumPuertos" runat="server" />
            <asp:HiddenField ID="hdnPortToolPos" runat="server" />
            <asp:HiddenField ID="hdnDelayWithStatus" runat="server" />
        </div>
    </ContentTemplate>
</asp:UpdatePanel>

<!-- tab-content loaded here -->
<asp:UpdatePanel runat="server" ID="UpdatePanelContentHerramientas" UpdateMode="Conditional">
    <ContentTemplate>
        <div class="item-ajax-holder">

            <div class="mode-panel">
                <div class="holder">
                    <div class="title-panel">
                        <span class="tool-select"><%= CurrentContext.Translator.Translate("TOOL_SELECT") %> <span class="title">
                            <asp:Label ID="lblHerrSelec" runat="server"></asp:Label></span></span>
                    </div>
                </div>
            </div>

            <div class="parameters-block">

<%--                <ul class="tabs">
                    <li id="li_SettingsSection" class="active" runat="server"><asp:LinkButton ID="btnToolSettingsSection" runat="server" CssClass="btn" CommandName="Settings"><%= CurrentContext.Translator.Translate("MSG_TOOLS_SECTION_SETTINGS")%></asp:LinkButton></li>
                    <li id="li_ProfilesSection" class="" runat="server"><asp:LinkButton ID="btnToolProfilesSection" runat="server" CssClass="btn" CommandName="Profiles"><%= CurrentContext.Translator.Translate("MSG_TOOLS_SECTION_PROFILES")%></asp:LinkButton></li>
                </ul>--%>

                <ul class="parameters-list jcf-scrollable" data-area="edit-area" runat="server" id="DivCamps">                
                    <asp:Repeater ID="repeater_parameters" runat="server" OnItemCommand="repeater_parameters_ItemCommand">
                        <ItemTemplate>
                            <li>
                                <div class="container">
                                    <asp:CheckBox CssClass="checkbox" ID="ChkParam" runat="server" Checked='<%# Eval("Active")%>' Enabled='<%# Eval("Editable")%>' Visible='<%# Eval("Visible")%>' AutoPostBack="true" CommandArgument='<%# Eval("ValuePosition")%>' OnCheckedChanged="ChkParam_CheckedChanged" />
                                    <asp:Label runat="server" CssClass="parameter-name" Text='<%# Eval("ParameterName")%>'></asp:Label>
                                    <asp:LinkButton ID='valor' CssClass="value" runat="server" Text='<%# Eval("Value")%>' Enabled='<%# Eval("Editable")%>' CommandName='<%# Eval("DataEntry")%>' CommandArgument='<%# Eval("ValuePosition")%>' />
                                </div>
                            </li>
                        </ItemTemplate>
                    </asp:Repeater>
                </ul>
            </div>

            <!--Panel de de formulario de entrada de datos -->
            <asp:Panel ID="PanelEntradaDatos" runat="server" Style="display: none" CssClass="error-message" DefaultButton="btnAceptar_PanelEntradaDatos">
                <div class="holder">
                    <asp:Literal ID="info_PanelEntradaDatos" runat="server"></asp:Literal>
                    <asp:DropDownList runat="server" ID="ucListaParam" CssClass="combo" Width="150" Style="margin: 0 auto; display: block !important;"></asp:DropDownList>
                    <asp:TextBox ID="value_PanelEntradaDatos" runat="server" Width="280" MaxLength="100" Style="margin: 0 auto;"></asp:TextBox>

                    <ajaxToolkit:FilteredTextBoxExtender ID="regnumint" runat="server" TargetControlID="value_PanelEntradaDatos" ValidChars="1234567890" />
                    <asp:RangeValidator ID="regValidator" ControlToValidate="value_panelEntradaDatos" MinimumValue="1" ForeColor="#ff6666" Font-Bold="true" MaximumValue="50" Type="Integer" Text="" runat="server" ValidationGroup="CONTROLDATOS"></asp:RangeValidator>
                    <br />
                    <asp:LinkButton ID="btnAceptar_PanelEntradaDatos" runat="server" CssClass="btn" ValidationGroup="CONTROLDATOS" OnClick="btnAceptar_PanelEntradaDatos_Click"><%= CurrentContext.Translator.Translate("ADMIN_BTN_DELETE_OK")%></asp:LinkButton>
                    <asp:LinkButton ID="btnCancelar_PanelEntradaDatos" runat="server" CssClass="btn"><%= CurrentContext.Translator.Translate("ADMIN_BTN_CANCEL")%></asp:LinkButton>
                </div>
            </asp:Panel>

            <!-- controles ocultos-->
            <asp:HiddenField ID="hdnPanelEntradaDatos" runat="server" />

            <!-- controles ajax-->
            <ajaxToolkit:ModalPopupExtender ID="MPE_PanelEntradaDatos" runat="server" TargetControlID="hdnPanelEntradaDatos" PopupControlID="PanelEntradaDatos" BackgroundCssClass="" DropShadow="false" PopupDragHandleControlID="" X="0" />

        </div>

        <asp:HiddenField ID="hdnCkLevel" runat="server" />
        <asp:HiddenField ID="hdnLevelCkeck" runat="server" />
        <asp:HiddenField ID="hdnActiveToolSection" runat="server" />
    </ContentTemplate>
</asp:UpdatePanel>

<asp:HiddenField ID="hdnTempMax" runat="server" />
<asp:HiddenField ID="hdnTempMin" runat="server" />

<asp:HiddenField ID="hdnTempLevels" runat="server" />
<ajaxToolkit:UpdatePanelAnimationExtender ID="UpdatePanelAnimationExtenderSliderHerramientas" TargetControlID="UpdatePanelSliderHerramientas" BehaviorID="animation" runat="server">
    <Animations>
    <OnUpdating>
        <Sequence>
            <ScriptAction Script="LockScreen();" />
        </Sequence>
    </OnUpdating>
    <OnUpdated>
        <Sequence>
            <ScriptAction Script="UnlockScreen(); initRefreshFunctions($('div.ajax-holder')); $('div.menu-herramientas').data('ScrollGallery').currentStep = currentstyle_menuherramientas; $('div.menu-herramientas div.slideset').attr('style', currentstyle_menuherramientas); initRefreshFunctions2($('div.ajax-holder'));"  />
        </Sequence>
    </OnUpdated>
    </Animations>
</ajaxToolkit:UpdatePanelAnimationExtender>

<ajaxToolkit:UpdatePanelAnimationExtender ID="UpdatePanelAnimationExtenderContentHerramientas" TargetControlID="UpdatePanelContentHerramientas" BehaviorID="animation" runat="server">
    <Animations>
    <OnUpdating>
        <Sequence>
            <ScriptAction Script="LockScreen();" />
        </Sequence>
    </OnUpdating>
    <OnUpdated>
        <Sequence>
            <ScriptAction Script="UnlockScreen(); initRefreshFunctions2($('div.ajax-holder'));"  />
        </Sequence>
    </OnUpdated>
    </Animations>
</ajaxToolkit:UpdatePanelAnimationExtender>

<asp:UpdateProgress ID="UpdateProgressContentHerramientas" runat="server" AssociatedUpdatePanelID="UpdatePanelContentHerramientas" DisplayAfter="100">
    <ProgressTemplate>
        <asp:Image ID="img_ajax_loading_MenuStation" runat="server" ImageUrl="~/images/ajax-loading.gif" CssClass="ajax_loading_centered" Style="z-index: 100002;" />
    </ProgressTemplate>
</asp:UpdateProgress>

<asp:UpdateProgress ID="UpdateProgressPanelSliderHerramientas" runat="server" AssociatedUpdatePanelID="UpdatePanelSliderHerramientas" DisplayAfter="100">
    <ProgressTemplate>
        <asp:Image ID="img_ajax_loading_Tools" runat="server" ImageUrl="~/images/ajax-loading.gif" CssClass="ajax_loading_centered" Style="z-index: 100002;" />
    </ProgressTemplate>
</asp:UpdateProgress>
